*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE UNINIT (OPTION)
*
*
* Purpose:
*     Initialize a Unix plot file
*
*
* Description:
*     A Unix plot file is opened and an initial space command to set
*     the plot limits is written to the file.
*
*
* Parameters:
* C ->  OPTION - Character string specifying the options.  Options are
*                separated by commas and/or whitespace (blanks, tabs,
*                or nulls).  If any option is omitted, the default
*                value is used.  An all blank string gives the default
*                values.  The same keyword may appear more than once,
*                with the last instance taking precedence.
*                FILENAME=name - Specifies the name of the file to
*                  which plot data is sent.  The file name is not used
*                  if this plot device is already active.  The special
*                  file name "*" can be  used to direct output to the
*                  standard output (Fortran unit 6).  The default file
*                  name is "unplot.dat".
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:29:54 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE UNINIT (OPTION)


      INTEGER NEKEY
      PARAMETER (NEKEY=1)

      INTEGER NC,N,NCN,IBO
      INTEGER LENSTR
      INTEGER*2 ISPACE(4)
      INTEGER IBYORD

      CHARACTER*(*) OPTION
      CHARACTER*256 LINE,TOKEN
      CHARACTER*20 KEYTAB(NEKEY)

      INTEGER LUNUN
      CHARACTER*255 FNAMUN
      COMMON /UNCOM/ LUNUN,FNAMUN
      DATA LUNUN/-1/,FNAMUN/'unplot.dat'/

      DATA KEYTAB/'FILE*NAME'      /
      DATA ISPACE/0,0,4095,4095/


      CALL RQUOTE(OPTION,LINE,NC)

* Decode the options
 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

        IF (N.EQ.1) THEN
          CALL RQUOTE(TOKEN(1:NC),FNAMUN,NCN)

        END IF

      GO TO 100
      END IF


      IF (LUNUN.LT.0) THEN

* Not previously selected
* Open the file
        IF (FNAMUN.EQ.'*') THEN
          LUNUN=6
        ELSE
          CALL FBAKUP(FNAMUN)
          CALL GETFUN(LUNUN)
          OPEN (UNIT=LUNUN,FILE=FNAMUN,STATUS='UNKNOWN')
        END IF

* Define the workspace (coordinates in machine-dependent byte order)
        IBO=IBYORD()
        CALL FPUTCN(LUNUN,'s')
        CALL FPUTI2(LUNUN,ISPACE,4,IBO)
        CALL FPUTCN(LUNUN,'e')

      END IF


      RETURN

      END
