*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE TKXY (IX, IY, LWIDTH)
*
*
* Purpose:
*     Draw a vector on a Tektronix display
*
*
* Description:
*     This routine writes a plot vector to the Tektronix display.
*
*
* Parameters:
* I ->  IX     - X coordinate in plotting units (0 to 4095)
* I ->  IY     - Y coordinate in plotting units (0 to 4095)
* I ->  LWIDTH - Line width (plot units).  A zero width line indicates
*                an invisible line.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:48 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE TKXY (IX, IY, LWIDTH)


      INTEGER DARK,VIS
      PARAMETER (DARK=0,VIS=1)

      INTEGER IX,IY,LWIDTH

      INTEGER LUNTK
      CHARACTER*255 FNAMTK
      COMMON /TKCOM/ LUNTK,FNAMTK


      IF (LWIDTH.NE.0) THEN
        CALL TKVECT(LUNTK,IX/4,IY/4,VIS)
      ELSE
        CALL TKVECT(LUNTK,IX/4,IY/4,DARK)
      END IF


      RETURN

      END
