*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE TKVECT (LUN, IX, IY, IVIS)
*
*
* Purpose:
*     Write a vector to a Tektronix display
*
*
* Description:
*     This routine accepts a pair of X-Y coordinates as input.  These
*     coordinates are broken up into high and low five bit addresses
*     for each coordinate.  In the worst case, the coordinates are sent
*     as a sequence of 4 characters to the Tektronix terminal.  This
*     routine takes advantage of the condition that the high or low
*     part of the Y coordinate or the high part of the X coordinate
*     does not change from one invokation of TKVECT to another.  In
*     this case the coordinates may be sent as an abbrieviated sequence
*     of 1, 2 or 3 characters.  The context can be initialized at the
*     beginning of plotting by a call to TKVECT(LUN,0,0,0).
*
*
* Parameters:
* I ->  LUN    - Unit number for the Tektronix terminal or file
* I ->  IX     - X coordinate, 0 to 1023 inclusive
* I ->  IY     - Y coordinate, 0 to 1023 inclusive, but only values
*                between 0 and 779 appear on the screen.  Note that
*                values of IX or IY outside the range 0 to 1023 are
*                taken modulo 1024.
* I ->  IVIS   - Visibility flag,
*                0 - Draw a dark vector to the point indicated.  The
*                    terminal is set to graphics mode.
*                1 - Draw a visible vector to the point indicated.  It
*                    is assumed that a dark vector has been drawn
*                    previously.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:45 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE TKVECT (LUN, IX, IY, IVIS)


      INTEGER MHY,MLY,MHX,MLX,GS
      PARAMETER (MHY=32,MLY=96,MHX=32,MLX=64,GS=29)

      INTEGER LUN,IX,IY,IVIS
      INTEGER N,IT
      INTEGER IHX,IHY,ILY

      CHARACTER*5 CBUFF

      SAVE IHX,IHY,ILY


* Initialize the context
      IF (IX.EQ.0 .AND. IY.EQ.0 .AND. IVIS.EQ.0) THEN
        IHX=-1
        IHY=-1
        ILY=-1
      END IF

      N=0

* Invoke graphics mode for IVIS=0
      IF (IVIS.EQ.0) THEN
        N=1
        CBUFF(1:1)=CHAR(GS)
      END IF

* The 10 bit coordinates are sent in 5 bit chunks
* Isolate the high order part of IY
      IT=MOD(IY/32,32)

      IF (IT.NE.IHY) THEN

* Put the high order part of IY in the buffer
        IHY=IT
        N=N+1
        CBUFF(N:N)=CHAR(IHY+MHY)
      END IF

* Isolate the high order part of IX
      IT=MOD(IX/32,32)

      IF (IT.NE.IHX) THEN

* Put the low order part of IY in the buffer
        ILY=MOD(IY,32)
        N=N+1
        CBUFF(N:N)=CHAR(ILY+MLY)

* Send the high order part of IX
        IHX=IT
        N=N+1
        CBUFF(N:N)=CHAR(IHX+MHX)

      ELSE

* Isolate the low order part of IY
        IT=MOD(IY,32)

        IF (IT.NE.ILY) THEN

* Put the low order part of IY in the buffer
          ILY=IT
          N=N+1
          CBUFF(N:N)=CHAR(ILY+MLY)
        END IF

      END IF

* Put the low order part of IX in the buffer
      N=N+1
      IT=MOD(IX,32)
      CBUFF(N:N)=CHAR(IT+MLX)

* Send the buffer to the terminal
      CALL FPUTCN(LUN,CBUFF(1:N))


      RETURN

      END
