*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE TKINIT (OPTION)
*
*
* Purpose:
*     Initialize a Tektronix display plot
*
*
* Description:
*     This subroutine opens a file for the Tektronix terminal.  It then
*     (optionally) clears the screen.
*
*
* Parameters:
* C ->  OPTION - Character string specifying the options.  Options are
*                separated by commas and/or whitespace (blanks, tabs,
*                or nulls).  If any option is omitted, the default
*                value is used.  An all blank string gives the default
*                values.  The same keyword may appear more than once,
*                with the last instance taking precedence.  The CLEAR
*                and OVERLAY options apply only to one invokation of
*                this routine.
*                CLEAR - The screen is erased.  CLEAR is the default
*                  option if this plot device is not active.
*                OVERLAY - The screen is not erased.  OVERLAY is the
*                  default option if this plot device is already
*                  active.
*                FILENAME=name - Specifies the name of the file or
*                  terminal to which plot data is sent.  The file name
*                  is not used if this plot device is already active.
*                  The special file name "*" can be  used to direct
*                  output to the standard output (Fortran unit 6).  The
*                  default file name is "/dev/tty".
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:29:42 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE TKINIT (OPTION)


      INTEGER DARK,ESC,FF,NEKEY
      PARAMETER (DARK=0,ESC=27,FF=12)
      PARAMETER (NEKEY=3)

      INTEGER NC,N,NCN
      INTEGER LENSTR

      CHARACTER*(*) OPTION
      CHARACTER*256 LINE,TOKEN
      CHARACTER*20 KEYTAB(NEKEY)

      LOGICAL CLEAR

      INTEGER LUNTK
      CHARACTER*255 FNAMTK
      COMMON /TKCOM/ LUNTK,FNAMTK
      DATA LUNTK/-1/,FNAMTK/'/dev/tty'/

      DATA KEYTAB/'CL*EAR'         , 'OVER*LAY'        ,
     -            'FILE*NAME'      /


      CLEAR=(LUNTK.LT.0)
      CALL RQUOTE(OPTION,LINE,NC)

* Decode the options
 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

        IF (N.EQ.1) THEN
          CLEAR=.TRUE.

        ELSE IF (N.EQ.2) THEN
          CLEAR=.FALSE.

        ELSE IF (N.EQ.3) THEN
          CALL RQUOTE(TOKEN(1:NC),FNAMTK,NCN)

        END IF

      GO TO 100
      END IF


      IF (LUNTK.LT.0) THEN

* Not previously selected
* Open the file
        IF (FNAMTK.EQ.'*') THEN
          LUNTK=6
        ELSE
          CALL FBAKUP(FNAMTK)
          CALL GETFUN(LUNTK)
          OPEN (UNIT=LUNTK,FILE=FNAMTK,STATUS='UNKNOWN')
        END IF

        IF (CLEAR) CALL FPUTCN(LUNTK,CHAR(ESC)//CHAR(FF))
        CALL TKVECT(LUNTK,0,0,0)

      ELSE IF (CLEAR) THEN

* Previously selected, with CLEAR option
        CALL FPUTCN(LUNTK,CHAR(ESC)//CHAR(FF))

      END IF


      RETURN

      END
