*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE TKEND
*
*
* Purpose:
*     Terminate a plot on a Tektronix terminal
*
*
* Description:
*     This subroutine draws a dark vector to (0,767) and sets the
*     Tektronix terminal back to alpha-numeric mode.
*
*
* Parameters:
*     None
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:29:39 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE TKEND


      INTEGER DARK
      PARAMETER (DARK=0)

      CHARACTER*1 US

      INTEGER LUNTK
      CHARACTER*255 FNAMTK
      COMMON /TKCOM/ LUNTK,FNAMTK


* Draw a vector to the home position
* Set the terminal to alpha-numeric mode
      CALL TKVECT(LUNTK,0,767,DARK)
      US=CHAR(31)
      CALL FPUTCN(LUNTK,US)

* Close the file
      IF (LUNTK.NE.6) THEN
        CLOSE (UNIT=LUNTK)
        CALL RELFUN(LUNTK)
      END IF

* Set the common area parameters to their default values
      LUNTK=-1
      FNAMTK='/dev/tty'


      RETURN

      END
