*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PSVECT (LUN, IX, IY, LINEWD)
*
*
* Purpose:
*     Write a vector to a Postscript plot file
*
*
* Description:
*     This routine writes a plot vector to a Postscript plot file.  The
*     plot commands written to the file makes use of macros defined by
*     routine PSHEAD.  Subroutine PSHEAD also initializes variables in
*     common area PSBBOX which tally bounding box information.
*
*
* Parameters:
* I ->  LUN    - Unit number for the file
* I ->  IX     - X coordinate in plotting units (0 to 4095)
* I ->  IY     - Y coordinate in plotting units (0 to 4095)
* I ->  LINEWD - Line width in plotting units
*                0 - no plot vector is generated
*                negative - a white vector of width -LINEWD
*                           is generated
*                positive - a black vector of width LINEWD
*                           is generated
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:33 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PSVECT (LUN, IX, IY, LINEWD)


      CHARACTER*10 STRL,STRX,STRY

      INTEGER LUN,IX,IY,LINEWD
      INTEGER NCL,NCX,NCY

      INTEGER IXMIN,IYMIN,IXMAX,IYMAX,LWP
      COMMON /PSBBOX/ IXMIN,IYMIN,IXMAX,IYMAX,LWP

      INTEGER IXP,IYP
      SAVE IXP,IYP
      DATA IXP,IYP/0,0/


* Update the maximum and minimum excursions
      IXMIN=MIN(IX,IXMIN)
      IYMIN=MIN(IY,IYMIN)
      IXMAX=MAX(IX,IXMAX)
      IYMAX=MAX(IY,IYMAX)

      IF (LINEWD.EQ.0) THEN

* Move
        CALL CONVIC(IX,STRX,NCX)
        CALL CONVIC(IY,STRY,NCY)
        WRITE (UNIT=LUN,FMT=1000) STRX(1:NCX)//' '//
     -                            STRY(1:NCY)//' m'


      ELSE

* Write the line width (if changed)
        IF (LINEWD.NE.LWP) THEN
          LWP=LINEWD
          CALL CONVIC(ABS(LWP),STRL,NCL)
          IF (LWP.GT.0) THEN
            WRITE (UNIT=LUN,FMT=1000) STRL(1:NCL)//' B'
          ELSE
            WRITE (UNIT=LUN,FMT=1000) STRL(1:NCL)//' W'
          END IF
        END IF

* Write the coordinates for the next line segment
        IF (IX.EQ.IXP) THEN
          CALL CONVIC(IY,STRY,NCY)
          WRITE (UNIT=LUN,FMT=1000) STRY(1:NCY)//' V'
        ELSE IF (IY.EQ.IYP) THEN
          CALL CONVIC(IX,STRX,NCX)
          WRITE (UNIT=LUN,FMT=1000) STRX(1:NCX)//' H'
        ELSE
          CALL CONVIC(IX,STRX,NCX)
          CALL CONVIC(IY,STRY,NCY)
          WRITE (UNIT=LUN,FMT=1000) STRX(1:NCX)//' '//
     -                                STRY(1:NCY)//' L'
        END IF

      END IF

* Update the coordinate positions
      IXP=IX
      IYP=IY


      RETURN

 1000 FORMAT (A)

      END
