*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PSTAIL (LUN)
*
*
* Purpose:
*     Write a trailer to a Postscript plot file
*
*
* Description:
*     This routine writes trailer information to a Postscript plot
*     file.  The first part of the trailer gives commands to plot the
*     accumulated data and the second part gives plot size information.
*
*
* Parameters:
* I ->  LUN    - Unit number for the file
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.7 $  $Date: 1995/03/08 15:29:30 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PSTAIL (LUN)


* PSCALE is the number of plotting units per Postscript point
      REAL PSCALE
      PARAMETER (PSCALE=0.12)

      CHARACTER*10 STXMIN,STYMIN,STXMAX,STYMAX

      INTEGER LUN
      INTEGER NCXMIN,NCXMAX,NCYMIN,NCYMAX

      INTEGER IXMIN,IYMIN,IXMAX,IYMAX,LWP
      COMMON /PSBBOX/ IXMIN,IYMIN,IXMAX,IYMAX,LWP


* Write a trailer to the file
      WRITE (UNIT=LUN,FMT=1000) 'stroke showpage end'
      WRITE (UNIT=LUN,FMT=1000) '%%Trailer'
      IF (IXMAX.GE.IXMIN .AND. IYMAX.GE.IYMIN) THEN
        CALL CONVIC(NINT(PSCALE*IXMIN)+36, STXMIN,NCXMIN)
        CALL CONVIC(NINT(PSCALE*IYMIN)+144,STYMIN,NCyMIN)
        CALL CONVIC(NINT(PSCALE*IXMAX)+36, STXMAX,NCXMAX)
        CALL CONVIC(NINT(PSCALE*IYMAX)+144,STYMAX,NCYMAX)
        WRITE (UNIT=LUN,FMT=1000) '%%BoundingBox: '//
     -      STXMIN(1:NCXMIN)//' '//STYMIN(1:NCYMIN)//' '//
     -      STXMAX(1:NCXMAX)//' '//STYMAX(1:NCYMAX)
      ELSE
        WRITE (UNIT=LUN,FMT=1000) '%%BoundingBox: 0 0 0 0'
      END IF
      WRITE (UNIT=LUN,FMT=1000) '%%EOF'


      RETURN

 1000 FORMAT (A)

      END
