*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PSINIT (OPTION)
*
*
* Purpose:
*     Initialize a Postscript plot file
*
*
* Description:
*     This subroutine opens an encapsulated Postscript plot file.  A
*     standard header is written to the file. This header sets up the
*     plot scaling to map the plotting coordinates (in the range 0 to
*     4095) to give 600 plotting units per inch.  The header also
*     defines macros to draw lines and move the current location.
*     The resulting Postscript file can optionally be submitted for
*     printing on a Postscript printer.  In this case, the file is
*     deleted after printing.
*
*
* Parameters:
* C ->  OPTION - Character string specifying the options.  Options are
*                separated by commas and/or whitespace (blanks, tabs,
*                or nulls).  If any option is omitted, the default
*                value is used.  An all blank string gives the default
*                values.  The same keyword may appear more than once,
*                with the last instance taking precedence.
*                FILENAME=name - Specifies the name of the file to
*                  which plot data is sent.  The file name is not used
*                  if this plot device is already active.  The special
*                  file name "*" can be  used to direct output to the
*                  standard output (Fortran unit 6).  The default file
*                  name is derived from the name of the image
*                  (xxx.epsf where xxx is the image name).
*                PRINT or NOPRINT - Specifies whether the Postscript
*                  file is to be queued for printing.  The default is
*                  NOPRINT.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:29:27 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PSINIT (OPTION)


      INTEGER NEKEY
      PARAMETER (NEKEY=3)

      INTEGER NC,N,NCN
      INTEGER LENSTR

      CHARACTER*(*) OPTION
      CHARACTER*256 LINE,TOKEN
      CHARACTER*255 IMAGNM
      CHARACTER*20 KEYTAB(NEKEY)

      INTEGER LUNPS,IPRTPS
      CHARACTER*255 FNAMPS
      COMMON /PSCOM/ LUNPS,IPRTPS,FNAMPS
      DATA LUNPS/-1/,IPRTPS/0/,FNAMPS/' '/

      DATA KEYTAB/'FILE*NAME'      , 'PRINT'          ,
     -            'NOPRINT'        /


      CALL RQUOTE(OPTION,LINE,NC)

* Decode the options
 100  IF (LENSTR(LINE).GT.0) THEN
        CALL FNDPAR(LINE,KEYTAB,NEKEY,TOKEN,NC,N)

        IF (N.EQ.1) THEN
          CALL RQUOTE(TOKEN(1:NC),FNAMPS,NCN)

        ELSE IF (N.EQ.2) THEN
          IPRTPS=1

        ELSE IF (N.EQ.3) THEN
          IPRTPS=0

        END IF

      GO TO 100
      END IF


      IF (LUNPS.LT.0) THEN

* Not previously selected
        IF (FNAMPS.EQ.' ') THEN
          IF (IPRTPS.EQ.0) THEN
            CALL GETIMG(IMAGNM,NC)
            FNAMPS=IMAGNM(1:NC)//'.epsf'
          ELSE
            CALL GFNTMP('.epsf',FNAMPS)
          END IF
        END IF

* Open the file
        IF (FNAMPS.EQ.'*') THEN
          LUNPS=6
          IPRTPS=0
        ELSE
          CALL FBAKUP(FNAMPS)
          CALL GETFUN(LUNPS)
          OPEN (UNIT=LUNPS,FILE=FNAMPS,STATUS='UNKNOWN')
        END IF

        CALL PSHEAD(LUNPS)

      END IF


      RETURN

      END
