*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PSHEAD (LUN)
*
*
* Purpose:
*     Write a header to a Postscript plot file
*
*
* Description:
*     This routine writes header information to an encapsulated
*     Postscript plot file.  This information includes the creator and
*     the date.  In addition the preamble text defines macros to carry
*     out the plotting.
*
*     Note: The bounding box information is placed in the trailer.
*           Before inclusion in another document, this information
*           should be moved to the header.
*
*
* Parameters:
* I ->  LUN    - Unit number for the file
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:29:25 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PSHEAD (LUN)


      CHARACTER*60 USER
      CHARACTER*20 DATTIM

      INTEGER LUN
      INTEGER NC

      INTEGER IXMIN,IYMIN,IXMAX,IYMAX,LWP
      COMMON /PSBBOX/ IXMIN,IYMIN,IXMAX,IYMAX,LWP


* Reset the bounding box calculations
      IXMIN=+1000000
      IYMIN=+1000000
      IXMAX=-1000000
      IYMAX=-1000000
      LWP=0

* Write a header to the file
      WRITE (UNIT=LUN,FMT=1000) '%!PS-Adobe-3.0 EPSF-3.0'
      WRITE (UNIT=LUN,FMT=1000) '%%Title: Graphics'
      WRITE (UNIT=LUN,FMT=1000) '%%Creator: PK plot package'
      CALL GETDAT(DATTIM)
      WRITE (UNIT=LUN,FMT=1000) '%%CreationDate: '//DATTIM
      CALL GETUSR(USER,NC)
      WRITE (UNIT=LUN,FMT=1000) '%%For: '//USER(1:NC)
      WRITE (UNIT=LUN,FMT=1000) '%%Pages: 1'
      WRITE (UNIT=LUN,FMT=1000) '%%BoundingBox: (atend)'

* Set up macros in a new dictionary
* Postscript notes:
* - The new dictionary helps keep tight rein on the definitions
* - A maximum of 1400 points are allowed in each path (PS limit
*   is 1500). /npath is a counter for the number of points.
*   /pathlimit is the maximum number of points allowed.  When this
*   limit gets exceeded, an extra /stroke and /moveto are inserted.
      WRITE (UNIT=LUN,FMT=1000) '8 dict begin'
      WRITE (UNIT=LUN,FMT=1000) '/npath 0 def'
      WRITE (UNIT=LUN,FMT=1000) '/pathlimit 1400 def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '/L {/npath npath 1 add def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '    npath pathlimit gt {currentpoint m} if'
      WRITE (UNIT=LUN,FMT=1000)
     -      '    lineto} bind def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '/H {currentpoint exch pop L} bind def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '/V {currentpoint pop exch L} bind def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '/m {stroke moveto /npath 0 def} bind def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '/B {currentpoint m 0 setgray setlinewidth} bind def'
      WRITE (UNIT=LUN,FMT=1000)
     -      '/W {currentpoint m 1 setgray setlinewidth} bind def'

* Define the transformation from user coordinates
* The Apple laserwriter has a letter size of 8.0 by 10.92 inches
* or 2400 by 3276 dots (300 dots/inch)
* Set up the mapping to have 600 plotting units per inch (2 plotting
* units per dot), i.e. scale points (1/72 inches) by 72/600=0.12.
* Shift the origin to (0.5,2) inches
      WRITE (UNIT=LUN,FMT=1000) '36 144 translate 0.12 0.12 scale'
      WRITE (UNIT=LUN,FMT=1000) '1 setlinecap 2 setlinejoin'


      RETURN

 1000 FORMAT (A)

      END
