*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PSEND
*
*
* Purpose:
*     Terminate a Postscript plot file
*
*
* Description:
*     This routine closes and optionally prints a Postscript plot file.
*
*
* Parameters:
*     None
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:29:22 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PSEND


      INTEGER LUNPS,IPRTPS
      CHARACTER*255 FNAMPS
      COMMON /PSCOM/ LUNPS,IPRTPS,FNAMPS


* Force any buffered plot vectors to be written
      CALL PSXY(0,0,0)

* Write a trailer to the file
      CALL PSTAIL(LUNPS)

* Close the Postscript plot file
      IF (LUNPS.NE.6) THEN
        CLOSE (UNIT=LUNPS)
        CALL RELFUN(LUNPS)
      END IF

* Queue the file for printing (delete after printing)
      IF (IPRTPS.NE.0) CALL PRFILE(FNAMPS,' ',.TRUE.)

* Set the common area parameters to their default values
      LUNPS=-1
      IPRTPS=0
      FNAMPS=' '


      RETURN

      END
