*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     REAL FUNCTION DMCINT (K, X, Y, N)
*
*
* Purpose:
*     Calculate a derivative for a cubic
*
*
* Description:
*     This routine calculates a derivative value that can be used to
*     generate piecewise monotone cubic hermite interpolants to the
*     given data values. If the input data has a local extremum at the
*     point at which the derivative is to be calculated, the derivative
*     corresponding to that point will be returned as zero.
*
*
* Parameters:
* R <-  DMCINT - Output derivative value corresponding to point K
*
* I ->  K      - Evaluation point (1 to N)
* R ->  X      - Input abscissa values.  These values must be in
*                increasing order.
* R ->  Y      - Input ordinate values
* I ->  N      - Number of data values. Only values in the neighborhood
*                of K will be used.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:25:36 $
*
*
*-----------------------------------------------------------------------

      REAL FUNCTION DMCINT (K, X, Y, N)


      INTEGER K,N

      REAL X(N),Y(N)
      REAL DMCINM,DMCINE


* Middle point
      IF (K.GT.1 .AND. K.LT.N) THEN
        DMCINT=DMCINM(X(K)-X(K-1),X(K+1)-X(K),
     -                Y(K)-Y(K-1),Y(K+1)-Y(K))

* End point: beginning
      ELSE IF (N.GT.2 .AND. K.EQ.1) THEN
        DMCINT=DMCINE(X(2)-X(1),X(3)-X(2),
     -                Y(2)-Y(1),Y(3)-Y(2))

* End point: end
      ELSE IF (K.EQ.N .AND. N.GT.2) THEN
        DMCINT=DMCINE(X(N)-X(N-1),X(N-1)-X(N-2),
     -                Y(N)-Y(N-1),Y(N-1)-Y(N-2))

* Special case: linear interpolation
      ELSE IF ((K.EQ.1 .OR. K.EQ.2) .AND. N.EQ.2) THEN
        DMCINT=DMCINM(X(2)-X(1),X(2)-X(1),
     -                Y(2)-Y(1),Y(2)-Y(1))

* Single reference point
      ELSE IF (K.EQ.1 .AND. N.EQ.1) THEN
        DMCINT=0.0

      ELSE
        CALL HALT('DMCINT - Invalid input value')

      END IF


      RETURN

      END
