*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE LOCEXT (Y, NPT, MXNEXT, IEXT, NEXT)
*
*
* Purpose:
*     Find the local extrema in a vector of values
*
*
* Description:
*     This subroutine examines an array of data for local extema.  The
*     positions of these extrema is recorded in an array of indices.
*     The absolute value of each index gives the position of an
*     extremum (1 to NPT), while the sign indicates whether the
*     extremum is a maximum (positive) or a minimum (negative).  For
*     an extremum which is in a region of constant values, the mid-
*     epoint is returned (rounded down for an even number of constant
*     values).  For an array which is entirely constant, the number of
*     extrema is set to zero.
*
*
* Parameters:
* R ->  Y      - Input array of data values
* I ->  NPT    - Number of data values
* I ->  MXNEXT - Maximum number of extrema to be found
* I <-  IEXT   - Array of indices.  The absolute value of each element
*                indicates the postion of an extremum,
*                1 <= ABS(IEXT(i)) <= NPT.  The sign of the elements
*                indicate whether the extremum is a maximum or a
*                minimum.  The indices are returned in ascending order,
*                with alternating signs.
* I <-  NEXT   - Number of extrema found.  Note that NEXT may be zero
*                if the data values are constant and NEXT can be larger
*                than MXNEXT.  In this case IEXT contains the locations
*                first MXNEXT extrema.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:24:23 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE LOCEXT (Y, NPT, MXNEXT, IEXT, NEXT)


      INTEGER NPT,MXNEXT,NEXT
      INTEGER L,IBC,MAXS,I
      INTEGER IEXT(MXNEXT)

      REAL Y(NPT)


* Search for extrema in the array
* MAXS indicates whether searching for a maximum or a minimum
* +1 maximum, -1 minimum, 0 any change
* IBC records the position of the last value which was different
* from its predecessor.  It is used to find the midpoint of a
* constant region.
      L=0
      IBC=1
      MAXS=0
      DO 100 I=2,NPT

        IF (Y(I).LT.Y(I-1)) THEN
          IF (MAXS.GE.0) THEN
            L=L+1
            IF (L.LE.MXNEXT) IEXT(L)=+((I-1-IBC)/2+IBC)
          END IF
          MAXS=-1
          IBC=I
        ELSE IF (Y(I).GT.Y(I-1)) THEN
          IF (MAXS.LE.0) THEN
            L=L+1
            IF (L.LE.MXNEXT) IEXT(L)=-((I-1-IBC)/2+IBC)
          END IF
          MAXS=+1
          IBC=I
        END IF

 100  CONTINUE

* Check the last point
      IF (NPT.GT.1) THEN
        IF (Y(NPT).LT.Y(NPT-1)) THEN
          L=L+1
          IF (L.LE.MXNEXT) IEXT(L)=-NPT
        ELSE IF (Y(NPT).GT.Y(NPT-1)) THEN
          L=L+1
          IF (L.LE.MXNEXT) IEXT(L)=+NPT
        ELSE
          IF (MAXS.GT.0) THEN
            L=L+1
            IF (L.LE.MXNEXT) IEXT(L)=+((NPT-IBC)/2+IBC)
          ELSE IF (MAXS.LT.0) THEN
            L=L+1
            IF (L.LE.MXNEXT) IEXT(L)=-((NPT-IBC)/2+IBC)
          END IF
        END IF
      END IF

* Return the number of extrema found
      NEXT=L


      RETURN

      END
