*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GEOINC (XMIN, XMAX, N, RSTEP, X)
*
*
* Purpose:
*     Generate geometrically increasing values
*
*
* Description:
*     The range [Xmin,Xmax] is to sampled with geometrically increasing
*     increments,
*
*                     i-1
*       X(i) = Xmin + SUM Xd(k) ,  for i=0,1,2,...,N-1 ,
*                     k=0
*
*     where Xd(k) is the increment between samples.  This increment
*     increases geometrically with k,
*
*                k
*       Xd(k) = R  Xd(0) .
*
*     The step increment is determined from the ratio of the largest
*     step to the smallest step,
*
*       Rstep = Xd(N-1)/Xd(0) .
*
*     Note that the step size in the numerator is really the step size
*     that would be used beyond Xmax.  The ratio of the actual largest
*     step size is
*
*       Xd(N-2)/Xd(0) = Rstep**((N-2)/(N-1)) .
*
*     For logarithmically spaced values, Rstep should be equal to
*     Xmax/Xmin.
*
*
* Parameters:
* R ->  XMIN   - Minimum value
* R ->  XMAX   - Maximum value
* I ->  N      - Number of points
* R ->  RSTEP  - Ratio of the largest step size to the smallest step
*                size.  For logarithmically spaced values, RSTEP should
*                be equal to XMAX/XMIN.
* R <-  X      - Array of N samples, from XMIN to XMAX
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:24:18 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GEOINC (XMIN, XMAX, N, RSTEP, X)


      INTEGER N
      INTEGER K

      REAL XMIN,XMAX,RSTEP
      REAL X(0:N-1)


      IF (RSTEP.NE.1.) THEN
        DO 120 K=0,N-1
          X(K)=XMIN+(XMAX-XMIN)*
     -            (RSTEP**(K/REAL(N-1))-1.)/(RSTEP-1.)
 120    CONTINUE

      ELSE
        DO 140 K=0,N-1
          X(K)=XMIN+K*(XMAX-XMIN)/(N-1)
 140    CONTINUE

      END IF


      RETURN

      END
