*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     COMPLEX FUNCTION RSPIIR (F, H, NSECT)
*
*
* Purpose:
*     Find the frequency response for an cascade IIR filter
*
*
* Description:
*     This function calculates the frequency response of an IIR filter
*     specified by its coefficients.  The filter is a cascade of second
*     order sections, with the z-transform of the i'th filter section
*     given as
*
*                h(1,i)*z**2 + h(2,i)*z + h(3,i)
*       H(i,z) = ------------------------------- .
*                   z**2 + h(4,i)*z + h(5,i)
*
*     The frequency response is the product of such sections, evaluated
*     with z=exp(j2 pi f).
*
*
* Parameters:
* X <-  RSPIIR - Resulting complex valued response
*
* R ->  F      - Normalized frequency (normally in the range 0 to 0.5)
* R ->  H      - Array of groups of 5 filter coefficients, each
*                defining a biquadratic filter section
* I ->  NSECT  - Number of filter sections
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:21:59 $
*
*
*-----------------------------------------------------------------------

      COMPLEX FUNCTION RSPIIR (F, H, NSECT)


      REAL PI2
      PARAMETER (PI2=6.283 185 307)

      INTEGER NSECT
      INTEGER K

      COMPLEX Z

      REAL F
      REAL H(5,*)


* Form the product of the response of each second order section
      Z=CMPLX(COS(PI2*F),SIN(PI2*F))
      RSPIIR=1.
      DO 100 K=1,NSECT
        RSPIIR=RSPIIR *
     -           ( ( H(1,K)*Z**2 + H(2,K)*Z + H(3,K) ) /
     -                    ( Z**2 + H(4,K)*Z + H(5,K) ) )
 100  CONTINUE


      RETURN

      END
