*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     COMPLEX FUNCTION RSPFIR (F, H, NCOF)
*
*
* Purpose:
*     Find the frequency response for an FIR filter
*
*
* Description:
*     This function calculates the frequency repsonse of a FIR filter
*     specified by its coefficients.  The response is given by
*
*              Nc-1       -n
*       H(z) = SUM  h(n) z   ,
*              n=0
*
*     evaluated with z=exp(j 2 pi f).
*
*
* Parameters:
* X <-  RSPFIR - Resulting complex valued response
*
* R ->  F      - Normalized frequency (normally in the range 0 to 0.5)
* R ->  H      - Filter coefficients
* I ->  NCOF   - Number of filter coefficients
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:21:56 $
*
*
*-----------------------------------------------------------------------

      COMPLEX FUNCTION RSPFIR (F, H, NCOF)


      REAL PI2
      PARAMETER (PI2=6.283 185 307)

      INTEGER NCOF
      INTEGER N

      REAL F
      REAL WT
      REAL H(0:NCOF-1)

      DOUBLE PRECISION DSUMR,DSUMI


      WT=PI2*F
      DSUMR=0D0
      DSUMI=0D0
      DO 100 N=0,NCOF-1
        DSUMR=DSUMR + DPROD(H(N),COS(WT*N))
        DSUMI=DSUMI + DPROD(H(N),-SIN(WT*N))
 100  CONTINUE

      RSPFIR=CMPLX(SNGL(DSUMR),SNGL(DSUMI))


      RETURN

      END
