*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     COMPLEX FUNCTION RSPCAS (F, H, NSECT)
*
*
* Purpose:
*     Find the frequency response for an analog filter
*
*
* Description:
*     This function calculates the frequency response of a cascade
*     analog filter specified by its coefficients.  The filter is a
*     cascade of second order sections, with the Laplace transform of
*     the i'th filter section given as
*
*                h(1,i)*s**2 + h(2,i)*s + h(3,i)
*       H(i,s) = ------------------------------- .
*                   s**2 + h(4,i)*s + h(5,i)
*
*     The frequency response is the product of such sections, evaluated
*     with s=jw.
*
*
* Parameters:
* X <-  RSPCAS - Resulting complex valued response
*
* R ->  F      - Frequency
* R ->  H      - Array of groups of 5 filter coefficients, each
*                defining a biquadratic filter section
* I ->  NSECT  - Number of filter sections
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:21:53 $
*
*
*-----------------------------------------------------------------------

      COMPLEX FUNCTION RSPCAS (F, H, NSECT)


      REAL PI2
      PARAMETER (PI2=6.283 185 307)

      INTEGER NSECT
      INTEGER K

      REAL F
      REAL W
      REAL H(5,*)

      COMPLEX RS


* Form the product of the response of each second order section
      W=PI2*F
      RS=1.0
      DO 100 K=1,NSECT

* Handle the case of a first order section separately
* (A first order section is necessarily specified as a second
* order section with a zero constant coefficient since the
* term in s**2 in the denominator is fixed at one.)
        IF (H(3,K).EQ.0.0 .AND. H(5,K).EQ.0.0) THEN
          RS=RS * ( CMPLX( -W*H(1,K), H(2,K) ) /
     -              CMPLX( -W, H(4,K) ) )
        ELSE
          RS=RS * ( CMPLX( H(3,K)-(W*W)*H(1,K), W*H(2,K) ) /
     -              CMPLX( H(5,K)-(W*W), W*H(4,K) ) )
        END IF
 100  CONTINUE

      RSPCAS=RS


      RETURN

      END
