*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     REAL FUNCTION GDLIIR (F, H, NSECT)
*
*
* Purpose:
*     Find the group delay for a cascade IIR filter
*
*
* Description:
*     This function calculates the group delay of an IIR filter
*     specified by its coefficients.  The filter is a cascade of second
*     order sections, with the z-transform of the i'th filter section
*     given as
*
*                h(1,i)*z**2 + h(2,i)*z + h(3,i)
*       H(i,z) = ------------------------------- .
*                   z**2 + h(4,i)*z + h(5,i)
*
*     The group delay in seconds at frequency f for a filter with
*     sampling frequency Fs can be calculated as
*
*       T = GDLIIR(f/Fs,H,NSECT) / Fs  .
*
*
* Parameters:
* R <-  GDLIIR - Group delay in samples
*
* R ->  F      - Normalized frequency (normally in the range 0 to 0.5)
* R ->  H      - Array of groups of 5 filter coefficients, each
*                defining a biquadratic filter section
* I ->  NSECT  - Number of filter sections
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.8 $  $Date: 1995/03/08 15:21:14 $
*
*
*-----------------------------------------------------------------------

      REAL FUNCTION GDLIIR (F, H, NSECT)


      REAL PI2
      PARAMETER (PI2=6.283 185 307)

      INTEGER NSECT
      INTEGER K

      REAL F
      REAL GDLSEC
      REAL COSW,SINW
      REAL H(5,*)


* Add the group delay of each second order section
      COSW = COS(PI2*F)
      SINW = SIN(PI2*F)
      GDLIIR = 0.0

      DO 100 K=1,NSECT

* The transfer function is
*
*                h(1,k)*z**2 + h(2,k)*z + h(3,k)
*         H(z) = -------------------------------
*                  z**2 + h(4,k)*z + h(5,k)

* Delay due to the numerator less the delay due to the denominator
	GDLIIR=GDLIIR + (GDLSEC(H(1,K),H(2,K),H(3,K),COSW,SINW) -
     -                   GDLSEC(1.0,H(4,K),H(5,K),COSW,SINW))

 100  CONTINUE


      RETURN

      END
