*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FLTIIR (X, NOUT, H, NSECT)
*
*
* Purpose:
*     Filter a signal using a cascade of biquad filters
*
*
* Description:
*     The i'th filter section has a z-transform
*
*                h(1,i)*z**2 + h(2,i)*z + h(3,i)
*       H(i,z) = ------------------------------- .
*                   z**2 + h(4,i)*z + h(5,i)
*
*     Each filter section needs an input sample, two past input samples
*     and two past output samples to calculate each output sample.  In
*     the cascade connection, the output of one section is the input to
*     another.  For NSECT sections, the total filter "memory" required
*     is MEM=2*(NSECT+1) values.  In this routine the input array has
*     MEM extra elements representing these past inputs and outputs.
*
*     The first two elements (X(1) and X(2)) are the two previous
*     outputs of the overall filter; the next two elements (X(3) and
*     X(4)) are previous outputs of the second to last filter section,
*     and so on up to elements X(MEM-1) and X(MEM) which are previous
*     input samples. The next NOUT values (X(MEM+1),...,X(MEM+NOUT))
*     are new input values.  The filter is processed one section at
*     a time, with intermediate outputs overlaying one another.
*     When finished, the NOUT new output points appear as X(3),...,
*     X(NOUT+2).  The top MEM elements of the output array 
*     (X(NOUT+1),...,X(NOUT+MEM)) are outputs of intermediate sections
*     and previous inputs.  These values are suitable for priming the
*     array for processing the next group of input samples.  This is
*     accomplished by moving the top MEM elements of the array to the
*     bottom of the array and appending NOUT new input values.
*
*
* Parameters:
* R <-> X      - Input/output array with NOUT+2*(NSECT+1) elements.  On
*                input, the first 2*(NSECT+1) elements represent filter
*                memory values.  The next NOUT values are new elements.
*                On output, NOUT new outputs are placed starting at the
*                third element.  The top 2*(NSECT+1) elements of the
*                output array can be used as filter memory values for
*                the next call to this routine.
* I ->  NOUT   - Number of output samples
* R ->  H      - Array of groups of 5 filter coefficients, each
*                defining a biquadratic filter section
* I ->  NSECT  - Number of filter sections
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:21:05 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FLTIIR (X, NOUT, H, NSECT)


      INTEGER NOUT,NSECT
      INTEGER K,I

      REAL X(-2*(NSECT+1):NOUT-1),H(5,NSECT)


      K=0
      DO 100 I=1,NSECT
        K=K-2
        CALL BIQUAD(X(K),X(K-2),NOUT,H(1,I))
 100  CONTINUE


      RETURN

      END
