*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FLTALL (X, NOUT, H, NCOF)
*
*
* Purpose:
*     Filter a signal using an all-pole filter
*
*
* Description:
*     For an all-pole IIR filter, the response is specified by the
*     direct-form feedback coefficients, h(i),
*
*               1                    N-1       -i
*       H(z) = ----  ,  where C(z) = SUM h(i) z    .
*              C(z)                  i=0
*
*     Normally, the first coefficient is unity, i.e. h(0)=1.  A non-
*     unity value will result in a gain scaling of the response.
*
*     The filter needs NCOF-1 past output samples to calculate each
*     output sample.  For this routine, the input array has NCOF-1
*     "memory" elements representing past output values.
*
*     The first NCOF-1 elements of X are the past outputs of the
*     filter.   The next NOUT values (X(NCOF), ... , X(NOUT+NCOF+1))
*     are new input values.  When finished, the NOUT new output
*     points appear as X(NCOF), ... ,X(NCOF+1+NOUT).  The top NCOF-1
*     elements of the output array (X(NOUT+1), ... , X(NOUT+NCOF+1))
*     are suitable for priming the array for processing the next group
*     of input samples.  This is accomplished by moving the top NCOF-1
*     elements of the array to the bottom of the array and appending
*     NOUT new input values.
*
*
* Parameters:
* R <-> X      - Input/output array with NOUT+NCOF-1 elements.  On
*                input, the first NCOF-1 elements represent filter
*                memory values (past output values).  The next NOUT
*                values starting with X(NCOF) are new input values.
*                On output, NOUT new outputs are placed starting at
*                X(NCOF).  The top NCOF-1 elements of the output array
*                can be used as filter memory values for the next call
*                to this routine.
* I ->  NOUT   - Number of output samples
* R ->  H      - Array of NCOF filter coefficients
* I ->  NCOF   - Number of filter coefficients for the denominator of
*                the filter system response
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:21:02 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FLTALL (X, NOUT, H, NCOF)


      INTEGER NOUT,NCOF
      INTEGER I,J

      REAL X(-NCOF+1:NOUT-1),H(0:NCOF-1)
      REAL SUM


      IF (H(0).EQ.0.0)
     -    CALL HALT('FLTALL - Non-causal impulse response')

      DO 120 I=0,NOUT-1
        SUM=X(I)
        DO 100 J=1,NCOF-1
          SUM=SUM - H(J)*X(I-J)
 100    CONTINUE
        X(I)=SUM/H(0)
 120  CONTINUE


      RETURN

      END
