*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE BIQUAD (X, Y, NOUT, H)
*
*
* Purpose:
*     Filter data using a biquadratic filter section
*
*
* Description:
*     The output is formed using the following relationship,
*
*       y(i) = h(1)*x(i) + h(2)*x(i-1) + h(3)*x(i-2)
*              - h(4)*y(i-1) - h(5)*y(i-2) .
*
*     The z-transform of the filter section is
*
*              h(1)*z**2 + h(2)*z + h(3)
*       H(z) = ------------------------- .
*                z**2 + h(4)*z + h(5)
*
*     The filtering procedure needs the present and past two input
*     samples and the past two output samples to form a new output
*     sample.  These are supplied as extensions to the input and output
*     arrays.
*
*     The arrays input array X and the output array Y can share
*     storage.  Consider an array A with NOUT+4 elements.  Let the
*     first two elements (A(1) and A(2)) represent past output values.
*     The next two elements (A(3) and A(4)) are past input values.  The
*     The next NOUT elements starting with A(5) are new input values.
*     In this case, the call is
*       CALL BIQUAD(A(3),A(1),NOUT,H) .
*     NOUT new output values are placed starting at A(3), overlaying
*     input values.  The last two input values (A(NOUT+3) and
*     A(NOUT+4)) remain intact.  These along with the last two output
*     values (A(NOUT+1) and A(NOUT+2)) are suitable for priming the
*     array for processing the next group of samples.  This can be
*     achieved by moving the top 4 elements of the array to the bottom
*     of the array and appending NOUT new input values.
*
*
* Parameters:
* R ->  X      - Input array with NOUT+2 elements.  The first two
*                elements, X(1) and X(2), represent past input samples.
*                The next NOUT samples are the current input samples.
* R <-> Y      - Output array with NOUT+2 elements.  The first two
*                elements, Y(1) and Y(2), represent past outputs and
*                must be supplied as input. The remaining NOUT elements
*                are defined by this routine.
* I ->  NOUT   - Number of output samples
* R ->  H      - Array of 5 filter coefficients defining the
*                biquadratic filter section
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:20:50 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE BIQUAD (X, Y, NOUT, H)


      INTEGER NOUT
      INTEGER I

      REAL X(-2:NOUT-1),Y(-2:NOUT-1),H(5)


      DO 100 I=0,NOUT-1
        Y(I) = H(1)*X(I)+H(2)*X(I-1)+H(3)*X(I-2)
     -         -H(4)*Y(I-1)-H(5)*Y(I-2)
 100  CONTINUE


      RETURN

      END
