*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     LOGICAL FUNCTION TTYFNM (FNAME)
*
*
* Purpose:
*     Determine if a file is a terminal device
*
*
* Description:
*     This function determines if the given file name is a terminal.
*
*
* Parameters:
* L <-  TTYFUN - Returned logical value,
*                TRUE  - The file is a terminal
*                FALSE - The file is not a terminal
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:08:16 $
*
*
*-----------------------------------------------------------------------

      LOGICAL FUNCTION TTYFNM (FNAME)


      INTEGER LUN,NC
      INTEGER LENSTR

      CHARACTER*(*) FNAME

      LOGICAL EX
      LOGICAL TTYFUN


      NC=LENSTR(FNAME)
      INQUIRE (FILE=FNAME(1:NC),EXIST=EX)

      IF (EX) THEN
        CALL GETFUN(LUN)
        OPEN (UNIT=LUN,FILE=FNAME(1:NC),STATUS='OLD')
        TTYFNM=TTYFUN(LUN)
        CLOSE (UNIT=LUN)
        CALL RELFUN(LUN)
      ELSE
        TTYFNM=.FALSE.
      END IF


      RETURN

      END
