*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE READCF (FNAME, MAXCOF, COEFF, NCOF, FLTTYP)
*
*
* Purpose:
*     Read a filter coefficient file
*
*
* Description:
*     This subroutine reads coefficients from a file.  The values are
*     assumed to be stored in records with a maximum of 80 characters
*     in the record.  Up to 256 values may appear in a record.
*     Multiple values in a record are separated by commas or white
*     space (blanks, tabs or null characters).  Records prefixed with
*     a ! are treated as comments.  The first record is assumed to be
*     of the form !xxx... .  The xxx characters are returned as the
*     filter type indicator.
*
*
* Parameters:
* C ->  FNAME  - Character string specifying the file name.  Trailing
*                whitespace is not considered significant.
* I ->  MAXCOF - Maximum number of coefficients to be read
* R <-  COEFF  - Output array of filter coefficients
* I <-  NCOF   - Number of filter coefficients
* C <-  FLTTYP - Identification character string from the first record.
*                This value is extracted from position 2 onwards if the
*                first character is an exclamation mark.  If the first
*                record is not a comment, this string is returned as
*                blank.  The following identification strings are
*                standard for filter files.
*                  ALL - all-pole filter
*                  CAS - cascade analog filter
*                  FIR - finite impulse response filter coefficients
*                  IIR - infinite impulse response filter coefficients
*                  WND - window coefficients
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:18:08 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE READCF (FNAME, MAXCOF, COEFF, NCOF, FLTTYP)


      INTEGER MAXMXN
      PARAMETER (MAXMXN=256)

      INTEGER MAXCOF,NCOF
      INTEGER LUN,NC,IREC,I,NVR,NV
      INTEGER LENSTR

      CHARACTER*(*) FNAME,FLTTYP
      CHARACTER*80 RECORD

      REAL COEFF(MAXCOF)


* Open the coefficient file
* Note: DEC Ultrix will not allow us to open a file which is protected
*       against write unless the READONLY option is specified.
      CALL GETFUN(LUN)
      NC=LENSTR(FNAME)
#ifdef ultrix
      OPEN (UNIT=LUN,FILE=FNAME(1:NC),STATUS='OLD',READONLY)
#else
      OPEN (UNIT=LUN,FILE=FNAME(1:NC),STATUS='OLD')
#endif

* Read the coefficients until end-of-file
      FLTTYP=' '
      IREC=0
      I=0

 100  CONTINUE
        NVR=MIN(MAXCOF-I,MAXMXN)
        READ (UNIT=LUN,FMT=1000,END=200) RECORD
        IREC=IREC+1
        NC=LENSTR(RECORD)
        IF (NC.GT.0) THEN
          IF (RECORD(1:1).EQ.'!') THEN
            IF (IREC.EQ.1) FLTTYP=RECORD(2:)
          ELSE IF (NVR.GT.0) THEN
            CALL RDRVAL(RECORD(1:NC),1,NVR,COEFF(I+1),NV)
            IF (NV.EQ.0) CALL HALT('READCF - Error detected')
            I=I+NV
          ELSE
            CALL HALT('READCF - Too many data records')
          END IF
        END IF
      GO TO 100

* Close the file
 200  NCOF=I
      CLOSE (UNIT=LUN)
      CALL RELFUN(LUN)


      RETURN

 1000 FORMAT (A)

      END
