*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE RDPLUN (LUN, PROMPT, LINE, NCHR, IEOF)
*
*
* Purpose:
*     Prompt and read a line of input from a Fortran unit
*
*
* Description:
*     This subroutine reads lines of input from a given Fortran unit.
*     A prompt string is printed if the input unit is associated with
*     a terminal.
*
*
* Parameters:
* I ->  LUN    - Fortran unit number
* C ->  PROMPT - Character string used as a prompt.  The prompt is
*                printed if unit LUN is associated with a terminal
*                and standard output (unit 6) is associated with a
*                terminal.
* C <-  LINE   - Character string for the input line.  The behaviour is
*                different for input from terminals and for input that
*                has been redirected to a file.  For terminal input, if
*                the length of LINE is insufficient, the input line is
*                truncated with a warning.  For input from a file, the
*                input line is truncated silently.  If NCHR is less
*                than the length of LINE, LINE is padded out with
*                blanks.
* I <-  NCHR   - Number of characters in the line.  NCHR is set to 0
*                on reaching end-of-file.  For terminal input, NCHR is
*                set to the length of the input line, including any
*                trailing blanks that have been entered.  For input
*                redirected to a file, NCHR is determined from the
*                position of the last non-blank character in LINE.
* I <-  IEOF   - End-of-file flag,
*                 0  - Normal value
*                -1  - End-of-file
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.2 $  $Date: 1995/03/08 15:08:04 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE RDPLUN (LUN, PROMPT, LINE, NCHR, IEOF)


      INTEGER ISTDOU
      PARAMETER (ISTDOU=6)

      INTEGER LUN,NCHR,IEOF
      INTEGER LENBLK

      CHARACTER*(*) PROMPT,LINE

      LOGICAL TTYFUN


* Write a prompt if the input is from a terminal
      IF (TTYFUN(LUN)) THEN
        IF (TTYFUN(ISTDOU)) WRITE (UNIT=ISTDOU,FMT=1000) PROMPT
        READ (UNIT=LUN,FMT=2000,END=200) NCHR,LINE

        IF (NCHR.GT.LEN(LINE)) THEN
          CALL WARN('LINEIN - Input line truncated')
          NCHR=LEN(LINE)
        END IF

      ELSE
* Non-terminal input
* Note:
*   With SunOS Fortran 4.1, the Q format is not valid for in-line
*   data in a script (requires seek ability).  It is not possible to
*   distinguish redirection to a file from redirection to in-line data
*   in a script.  For all non-terminal inputs, the read is done without
*   the Q format and the length of the line is determined by finding
*   the last non-blank character.
        READ (UNIT=LUN,FMT=2100,END=200) LINE
        NCHR=LENBLK(LINE)

      END IF
      IEOF=0
      GO TO 900

* End-of-file found
 200  NCHR=0
      LINE=' '
      IEOF=-1


 900  RETURN

 1000 FORMAT (A,$)
 2000 FORMAT (Q,A)
 2100 FORMAT (A)

      END
