*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE PRFILE (FNAME, PRINTR, DELFLG)
*
*
* Purpose:
*     Print a file (optionally delete the file)
*
*
* Description:
*     This routine prints a file.  The printer to be used can be
*     selected.  Optionally, the file is deleted after printing.  This
*     routine executes the command "pr [-r] [-P printer] filename".
*     The printer selection "-P printer" is only used if the parameter
*     PRINTR is not blank.  The "-r" option is placed in the command
*     line if DELFLG is .TRUE. .
*
*
* Parameters:
* C ->  FNAME  - File name for file to be printed
* C ->  PRINTR - Printer to be used.  If this string is blank, the
*                default printer is selected.
* L ->  DELFLG - Logical variable.  If .TRUE. delete the file when it
*                has been printed.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:07:58 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE PRFILE (FNAME, PRINTR, DELFLG)


      INTEGER MXLINE
      PARAMETER (MXLINE=1024)

      INTEGER NL,NC,NT
      INTEGER LENSTR

      LOGICAL DELFLG

      CHARACTER*(*) FNAME,PRINTR
      CHARACTER*(MXLINE) LINE


* Insert the verb
      LINE(1:4)='lpr '
      NL=4
      IF (DELFLG) THEN
        LINE(NL+1:NL+3)='-r '
        NL=NL+3
      END IF

* Insert the printer
      NC=LENSTR(PRINTR)
      IF (NC.GT.0) THEN
        LINE(NL+1:NL+3)='-P '
        NL=NL+3
        CALL STTRIM(PRINTR(1:NC),LINE(NL+1:),NT)
        NL=NL+NT
        IF (NL.GE.MXLINE) CALL HALT('PRFILE - String truncated')
        LINE(NL+1:NL+1)=' '
        NL=NL+1
      END IF

* Insert the file name
      CALL STTRIM(FNAME,LINE(NL+1:),NC)
      NL=NL+NC

* Execute the print command
      CALL SYSTEM(LINE(1:NL))


      RETURN

      END
