*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION IBYORD ()
*
*
* Purpose:
*     Determine the byte order for data storage
*
*
* Description:
*     This function returns a code indicating whether the storage order
*     for the current host is little-endian or big-endian.  For big-
*     endian machines the constituent bytes in a multi-byte entity
*     are stored from most significant (lowest address) to least
*     significant address.  For little-endian machines, bytes are
*     stored from least significant to most significant.
*
*
* Parameters:
* I <-  IBYORD - Returned integer code
*                0 - Little-endian storage order
*                1 - Big-endian storage order
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.3 $  $Date: 1995/03/08 15:18:38 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION IBYORD ()


      INTEGER*4 IA1,IA2,ILEND
      PARAMETER (IA1=2,IA2=1,ILEND=IA1+IA2*65536)

      INTEGER*4 IV4
      INTEGER*2 IV2(2)

      EQUIVALENCE (IV4,IV2)
      DATA IV2/IA1,IA2/
      SAVE IV4,IV2


      IF (IV4.EQ.ILEND) THEN
        IBYORD=0
      ELSE
        IBYORD=1
      END IF


      RETURN

      END
