*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE LINEIN (PROMPT, LINE, NCHR, IEOF)
*
*
* Purpose:
*     Read a line of input from standard input
*
*
* Description:
*     This subroutine reads lines of input from standard input (Fortran
*     unit 5).  A prompt string is printed if the input unit is
*     associated with a terminal.
*
*
* Parameters:
* C ->  PROMPT - Character string used as a prompt.  The prompt
*                is printed if standard input (Fortran unit 6) is
*                associated with a terminal and standard output (unit
*                6) is associated with a terminal.
* C <-  LINE   - Character string for the input line.  The behaviour is
*                different for input from terminals and for input that
*                has been redirected to a file.  For terminal input, if
*                the length of LINE is insufficient, the input line is
*                truncated with a warning.  For input from a file, the
*                input line is truncated silently.  If NCHR is less
*                than the length of LINE, LINE is padded out with
*                blanks.
* I <-  NCHR   - Number of characters in the line.  NCHR is set to 0
*                on reaching end-of-file.  For terminal input, NCHR is
*                set to the length of the input line, including any
*                trailing blanks that have been entered.  For input
*                redirected to a file, NCHR is determined from the
*                position of the last non-blank character in LINE.
* I <-  IEOF   - End-of-file flag,
*                 0  - Normal value
*                -1  - End-of-file
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.7 $  $Date: 1995/03/08 15:07:46 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE LINEIN (PROMPT, LINE, NCHR, IEOF)


      INTEGER ISTDIN
      PARAMETER (ISTDIN=5)

      INTEGER NCHR,IEOF

      CHARACTER*(*) PROMPT,LINE


      CALL RDPLUN(ISTDIN,PROMPT,LINE,NCHR,IEOF)


      RETURN

      END
