*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GFNTMP (TEMPL, FNAMEO)
*
*
* Purpose:
*     Generate a unique file name for a temporary file
*
*
* Description:
*     This routine generates a unique file name suitable for use as a
*     name for a temporary file.  The name is of the form
*         directory // prefix // pid // letter // .postfix
*     The directory string, prefix string and postfix strings are
*     supplied in PATTN.  If the directory part is blank, the
*     environment variable TMPDIR is used as the directory.  If this
*     variable is not defined, the directory /tmp is used.  If the
*     prefix string is blank, the name of the image (truncated to 9
*     characters) is used as the prefix string.  The postfix string is
*     a trailing string starting with a period.  There is no default
*     for this string.  The middle part of the file name is formed from
*     the process id (decimal) with an appended letter.  The appended
*     letter starts at 'a' and is incremented if a file with the given
*     name already exists.
*
*     For any process, this routine generates a maximum of 26 unique
*     file names when called with the same template.
*
*     Examples:
*       CALL GFNTMP('./ABC.xyz',FNAMEO)
*          FNAMEO = './ABC17896a.xyz'
*       CALL GFNTMP('ABC.xyz',FNAMEO)
*          FNAMEO = '/tmp/ABC17896a.xyz'
*       CALL GFNTMP(' ',FNAMEO)
*          FNAMEO = '/tmp/program17896a'
*
*
* Parameters:
* C ->  TEMPL  - File name template string
* C <-  FNAMEO - Output file name
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:07:43 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GFNTMP (TEMPL, FNAMEO)


      INTEGER MAXN
      PARAMETER (MAXN=256)

      INTEGER NCD,NCN,IPID,NC,NCT,NP,I,K
      INTEGER IST
      INTEGER LENBLK,GETPID

      CHARACTER*(*) TEMPL,FNAMEO
      CHARACTER*(MAXN+1) FDIR
      CHARACTER*(MAXN+11) FNAM
      CHARACTER*(MAXN) FTYP
      CHARACTER*(MAXN+MAXN+MAXN+12) TSTR

      LOGICAL FEX

      SAVE IST

      CHARACTER*1 IC(0:25)
      DATA IC/'a','b','c','d','e','f','g','h','i','j',
     -        'k','l','m','n','o','p','q','r','s','t',
     -        'u','v','w','x','y','z'/

      DATA IST/0/

* Parse the file name
* Leave space MAXN characters for the name part, to which are
* added the process id (10 characters max) and a single letter suffix.
      CALL FNPARS(TEMPL,FDIR,FNAM(1:MAXN),FTYP)

* Fill in defaults for the file name if necessary
      NCD=LENBLK(FDIR)
      IF (NCD.LE.0) THEN
        CALL GETENV('TMPDIR',FDIR(1:MAXN))
        NCD=LENBLK(FDIR(1:MAXN))
        IF (NCD.EQ.0) THEN
          NCD=5
          FDIR(1:NCD)='/tmp/'
        ELSE IF (FDIR(NCD:NCD).NE.'/') THEN
          NCD=NCD+1
          FDIR(NCD:NCD)='/'
        END IF
      END IF

* Get the prefix string (image name)
      NCN=LENBLK(FNAM(1:MAXN))
      IF (NCN.LE.0) THEN
        CALL GETIMG(FNAM,NCN)
        NCN=MIN(9,NCN)
      END IF

* Get the process id
* (The format assumes that the pid will be at most 10 characters long)
      IPID=GETPID()
      WRITE (UNIT=TSTR,FMT=1000) IPID
      CALL STTRIM(TSTR,FNAM(NCN+1:),NC)
      NCN=NCN+NC

* Leave room for a single letter
      NCN=NCN+1
      FNAM(NCN:NCN)='a'

* Trial file name: directory, name and postfix
      TSTR=FDIR(1:NCD)//FNAM(1:NCN)
      NCT=NCD+NCN
      IF (FTYP.NE.' ') THEN
        NC=LENBLK(FTYP)
        TSTR(NCT+1:)=FTYP(1:NC)
        NCT=NCT+NC
      END IF

* Insert different letters at TSTR(NP:NP)
      NP=NCD+NCN
      DO 200 I=0,25
        K=MOD(I+IST,26)
        TSTR(NP:NP)=IC(K)
        INQUIRE (FILE=TSTR(1:NCT),EXIST=FEX)
        IF (.NOT.FEX) GO TO 800
 200  CONTINUE
      CALL HALT('GFNTMP - Unable to generate temporary file name')

* Return the file name
 800  IST=K+1
      CALL STCOPY(TSTR(1:NCT),FNAMEO,NC)

      RETURN

 1000 FORMAT (I10.5)

      END
