*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE GETFUN (LUN)
*     SUBROUTINE RELFUN (LUN)
*
*
* Purpose:
*     Allocate a Fortran unit number
*     Release a Fortran unit number
*
*
* Description:
*     These routines allocate and release Fortran unit numbers from a
*     pool of unit numbers.
*
*
* Parameters:
*     For SUBROUTINE GETFUN (LUN)
* I <-  LUN    - Returned logical unit number
*
*     For SUBROUTINE RELFUN (LUN)
* I ->  LUN    - Logical unit number to be released
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:07:40 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE GETFUN (LUN)


      INTEGER ALLOC,FREE,MAXFUN
      PARAMETER (ALLOC=1,FREE=0,MAXFUN=20)

      INTEGER LUN
      INTEGER I

      INTEGER FUNTAB(MAXFUN,2)
      SAVE FUNTAB
      DATA FUNTAB/
     -  31,30,29,28,27,26,25,24,23,22,
     -  21,20,19,18,17,16,15,14,13,12,
     -  FREE,FREE,FREE,FREE,FREE,FREE,FREE,FREE,FREE,FREE,
     -  FREE,FREE,FREE,FREE,FREE,FREE,FREE,FREE,FREE,FREE/


* Look for a free entry in the unit number table
      DO 100 I=1,MAXFUN
        IF (FUNTAB(I,2).EQ.FREE) THEN
          FUNTAB(I,2)=ALLOC
          LUN=FUNTAB(I,1)
          GO TO 200
        END IF
 100  CONTINUE
      CALL HALT('GETFUN - Allocatable units exhausted')


 200  RETURN


********************
      ENTRY RELFUN (LUN)


* Look for the unit number in the unit number table
      DO 500 I=1,MAXFUN
        IF (FUNTAB(I,1).EQ.LUN) THEN
          FUNTAB(I,2)=FREE
          GO TO 600
        END IF
 500  CONTINUE
      CALL WARN('RELFUN - Unit not previously allocated')


 600  RETURN

      END
