*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FRENAM (FNAMS, FNAMN)
*
*
* Purpose:
*     Rename a file
*
*
* Description:
*     This subroutine renames a file to a given name.  This operation
*     will overwrite data in the target file name if such a file
*     already exists.
*
*
* Parameters:
* C ->  FNAMS  - Original file name
* C ->  FNAMN  - New file name
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:07:37 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FRENAM (FNAMS, FNAMN)


      INTEGER ISTAT,NCN,NCS
      INTEGER LENSTR,LINK,UNLINK

      CHARACTER*(*) FNAMS,FNAMN

      LOGICAL EX


* Rename an existing file
* (a) Unlink XXX~ if it exists
* (b) Link XXX~ to the old file
* (c) Unlink XXX
      NCN=LENSTR(FNAMN)
      NCS=LENSTR(FNAMS)
      INQUIRE (FILE=FNAMN(1:NCN),EXIST=EX)
      IF (EX) THEN
        ISTAT=UNLINK(FNAMN(1:NCN))
          IF (ISTAT.NE.0) CALL PSYERR('FRENAM - Cannot rename file')
      END IF
      ISTAT=LINK(FNAMS(1:NCS),FNAMN(1:NCN))
        IF (ISTAT.NE.0) CALL PSYERR('FRENAM - Cannot rename file')
      ISTAT=UNLINK(FNAMS(1:NCS))
        IF (ISTAT.NE.0) CALL PSYERR('FRENAM - Cannot rename file')


      RETURN

      END
