*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FPUTI2 (LUN, I2VAL, N, IBO)
*
*
* Purpose:
*     Write INTEGER*2 values to a file (bypass Fortran I/O)
*
*
* Description:
*     This subroutine writes INTEGER*2 data to the file associated
*     with the given Fortran unit number.  The data are written using
*     routine FPUTC which bypasses normal Fortran I/O.  The data are
*     written to the file as a stream of bytes.  The byte order in the
*     file is determined by the IBO argument.
*
*
* Parameters:
* I ->  LUN    - Fortran unit number associated with the file
* I1 -> I2VAL  - Array of INTEGER*2 data to be written
* I ->  N      - Number of data values to be written
* I ->  IBO    - The byte order for the file
*                0 - The low-order byte is written first
*                1 - The high-order byte is written first
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:07:34 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FPUTI2 (LUN, I2VAL, N, IBO)


      INTEGER LUN,N,IBO
      INTEGER I,ISTAT1,ISTAT2
      INTEGER FPUTC
      INTEGER*2 I2VAL(*),I2

      CHARACTER*2 CHR
      EQUIVALENCE (I2,CHR)


      DO 100 I=1,N

* Write one byte at a time
        I2=I2VAL(I)
        IF (IBO.EQ.0) THEN
          ISTAT1=FPUTC(LUN,CHR(1:1))
          ISTAT2=FPUTC(LUN,CHR(2:2))
        ELSE
          ISTAT1=FPUTC(LUN,CHR(2:2))
          ISTAT2=FPUTC(LUN,CHR(1:1))
        END IF
        IF (ISTAT1.NE.0 .OR. ISTAT2.NE.0)
     -      CALL PSYERR('FPUTI2 - System error return from FPUTC')

 100  CONTINUE


      RETURN

      END
