*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FPUTCN (LUN, STRING)
*
*
* Purpose:
*     Write characters to a file (bypass Fortran I/O)
*
*
* Description:
*     This subroutine writes character data to the file associated with
*     the given Fortran unit number.  The characters are written using
*     routine FPUTC which bypasses normal Fortran I/O.
*
*
* Parameters:
* I ->  LUN    - Fortran unit number associated with the file
* C ->  STRING - Character string to be written
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:07:32 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FPUTCN (LUN, STRING)


      INTEGER LUN
      INTEGER I,ISTAT
      INTEGER FPUTC

      CHARACTER*(*) STRING


      DO 100 I=1,LEN(STRING)
        ISTAT=FPUTC(LUN,STRING(I:I))
        IF (ISTAT.NE.0)
     -    CALL PSYERR('FPUTCN - System error return from FPUTC')
 100  CONTINUE


      RETURN

      END
