*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FNPARS (FNAMIN, FPATH, FNAME, FTYPE)
*
*
* Purpose:
*     Parse a file name into constituent parts
*
*
* Description:
*     This routine takes a file name and parses into the path name
*     (directory string), the file name proper, and the file type.  The
*     file type is the part of the file name beginning with a period.
*
*
* Parameters:
* C ->  FNAMIN - Input character string containing the input file name
*                to be parsed
* C <-  FPATH  - Path name string.  If present, the path name is
*                terminated with a '/' character.  This string is
*                padded out with blanks.
* C <-  FNAME  - File name string.  This string is padded out with
*                blanks.
* C <-  FTYPE  - File type string.  If present, the file type string
*                begins with a '.' character.  This string is padded
*                out with blanks.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:07:29 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FNPARS (FNAMIN, FPATH, FNAME, FTYPE)


      INTEGER IP,IT,LT,IS,LP,LN
      INTEGER INDEXR,LENSTR,LOCNBL

      CHARACTER*(*) FNAMIN,FPATH,FNAME,FTYPE


      IP=INDEXR(FNAMIN,'/')
      IT=INDEXR(FNAMIN,'.')

* Fill in the file type
      IF (IT.GT.IP) THEN
        LT=LENSTR(FNAMIN(IT:))
        FTYPE=FNAMIN(IT:)
      ELSE
        IT=LENSTR(FNAMIN)+1
        LT=0
        FTYPE=' '
      END IF

* Fill in the path name
      IF (IP.GT.0) THEN
        IS=LOCNBL(FNAMIN(1:IP))
        LP=IP-IS+1
        FPATH=FNAMIN(IS:IP)
      ELSE
        LP=0
        FPATH=' '
      END IF

* Fill in the file name
      LN=IT-IP-1
      FNAME=FNAMIN(IP+1:IT-1)

* Error checks
      IF (LT.GT.LEN(FTYPE) .OR. LP.GT.LEN(FPATH) .OR.
     -    LN.GT.LEN(FNAME))
     -  CALL WARN('FNPARS - String truncated')


      RETURN

      END
