*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FFNAME (FNAMEI, FNAMEO)
*
*
* Purpose:
*     Fill in a directory path for a file name
*
*
* Description:
*     This routine takes an input file name and fills in the full path
*     name.  If the input file specification does not include a path
*     name, the path is determined from the current working directory.
*     In addition, the ~/ specification is recognized as the user's
*     home directory.
*
*     Form:
*     ~/abc/def    use the home directory (from the environment
*                  variable HOME)
*     abc/def      use the current working directory
*     /abc/def     full path supplied
*
*     This routine does not check to see if the path name exists.  In
*     addition, imbedded ./ directory specifications are removed.
*
*
* Parameters:
* C ->  FNAMEI - Input character string containing the file name.  If
*                the input name is null, the output name is the current
*                working directory with a trailing /.
* C <-  FNAMEO - Character string for the output file name.  This
*                string can be the same as the input string.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.9 $  $Date: 1995/03/08 15:07:14 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FFNAME (FNAMEI, FNAMEO)


      INTEGER MAXC
      PARAMETER (MAXC=255)

      INTEGER LD,LN,LT,NC,I,LDD
      INTEGER LENBLK

      CHARACTER*(*) FNAMEI,FNAMEO
      CHARACTER*(MAXC) FDIR,FNAM,FTYP
      CHARACTER*(MAXC+1) CWD,TEMP,HOME


* Parse the file name into components
      CALL FNPARS(FNAMEI,FDIR,FNAM,FTYP)

* Replace a leading ~ component with the home directory
      LD=LENBLK(FDIR)
      IF (FDIR(1:LDD).EQ.'~') THEN
        CALL GETENV('HOME',HOME)
        NC=LENBLK(HOME)
        FDIR=HOME
        LD=NC
      ELSE IF (FDIR(1:2).EQ.'~/') THEN
        CALL GETENV('HOME',HOME)
        NC=LENBLK(HOME)
        TEMP=HOME(1:NC) // FDIR(2:)
        FDIR=TEMP
        LD=NC+LD-1
      END IF

* Add the current working directory if the path is not absolute
      IF (LD.EQ.0) THEN
        CALL GETCWD(CWD)
        NC=LENBLK(CWD)
        FDIR=CWD(1:NC) // '/'
        LD=NC+1
      ELSE IF (FDIR(1:1).NE.'/') THEN
        CALL GETCWD(CWD)
        NC=LENBLK(CWD)
        TEMP=CWD(1:NC) // '/' // FDIR
        FDIR=TEMP
        LD=LD+NC+1
      END IF
      LDD=LD

* Remove /./ path components
 100  I=INDEX(FDIR,'/./')
      IF (I.NE.0) THEN
        TEMP=FDIR(1:I) // FDIR(I+3:)
        FDIR=TEMP
        LD=LD-2
      GO TO 100
      END IF

* Form the output string
      LN=LENBLK(FNAM)
      LT=LENBLK(FTYP)
      FNAMEO=FDIR(1:LD) // FNAM(1:LN) // FTYP(1:LT)

* Error check
      IF (LDD.GT.LEN(FDIR) .OR. LD+LN+LT.GT.LEN(FNAMEO)) THEN
        CALL WARN('FFNAME - File name too long')
        FNAMEO=FNAMEI
      END IF


      RETURN

      END
