*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FBAKUP (FNAME)
*
*
* Purpose:
*     Rename an existing file
*
*
* Description:
*     This subroutine backs up a file.  If a file with the given name
*     already exists, say XXX, that file is renamed to XXX~.  Any
*     previous file with the name XXX~ is removed.  Files corresponding
*     to terminals are not backed up.  If a backup file is created, a
*     warning message indicating the new name is issued.
*
*     One use of this routine is to backup files before issuing an
*     OPEN.  Note that since terminal files of the given name may
*     exist, the OPEN statement should use STATUS='UNKNOWN'.
*
*
* Parameters:
* C ->  FNAME  - File name
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:07:11 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FBAKUP (FNAME)


      INTEGER NC,NT
      INTEGER LENSTR

      CHARACTER*(*) FNAME
      CHARACTER*255 FTEMP

      LOGICAL EX,TTYFNM


* Check for an existing file
      NC=LENSTR(FNAME)
      INQUIRE (FILE=FNAME(1:NC),EXIST=EX)

      IF (EX) THEN

* Check if the file is a teletype
        IF (.NOT.TTYFNM(FNAME(1:NC))) THEN

* Rename an existing file to XXX~
          FTEMP=FNAME(1:NC)//'~'
          CALL FRENAM(FNAME,FTEMP)
          NT=MIN(NC+1,LEN(FTEMP))
          CALL WARN('FBAKUP - Renamed old file to '//
     -              FTEMP(1:NT))

        END IF

      END IF


      RETURN

      END
