*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VSHIFT (X, NKEEP, NSHIFT)
*
*
* Purpose:
*     Shift the elements of a vector
*
*
* Description:
*     This routine shifts the elements of a real vector.  If the number
*     of elements to be retained is zero, no action is taken.
*
*     For a shift down (NSHIFT positive), the elements of the array are
*     shifted down to the bottom of the array.  The input array must
*     have at least NKEEP+NSHIFT elements.
*       X(NSHIFT+i) --> X(i) , for i from 1 to NKEEP.
*
*     For a shift up (NSHIFT negative), the elements of the array are
*     shifted up to the top of the array.  The input array must have at
*     least NKEEP-NSHIFT elements (note that NSHIFT is negative).
*       X(i) --> X(i-NSHIFT), for i from NKEEP to 1.
*
*
* Parameters:
* R <-> X      - Input array
* I ->  NKEEP  - Number of elements to be retained.  NKEEP equal to
*                zero is allowed.
* I ->  NSHIFT - Number of positions to be shifted.  NSHIFT is positive
*                for a shift down and negative for a shift up.  NSHIFT
*                equal to zero is allowed.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:05:54 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VSHIFT (X, NKEEP, NSHIFT)


      INTEGER NKEEP,NSHIFT
      INTEGER I

      REAL X(*)


* Shift down
      IF (NSHIFT.GT.0) THEN
        DO 100 I=1,NKEEP
          X(I)=X(NSHIFT+I)
 100    CONTINUE

* Shift up
      ELSE IF (NSHIFT.LT.0) THEN
        DO 200 I=NKEEP,1,-1
          X(I-NSHIFT)=X(I)
 200    CONTINUE

      END IF


      RETURN

      END
