*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VLUB (X, N, XVAL, XLUB, INDX)
*
*
* Purpose:
*     Smallest value in a vector greater than a given value
*
*
* Description:
*     This subroutine searches the input array for the smallest element
*     which is greater than or equal to XVAL.  If no element is greater
*     than or equal to XVAL, the value XVAL is returned.
*
*
* Parameters:
* R ->  X      - Input array of values
* I ->  N      - Number of elements in X
* R ->  XVAL   - Reference value
* R <-  XLUB   - Returned value, XLUB=X(INDX) if INDX > 0
*                                XLUB=XVAL    if INDX = 0
* I <-  INDX   - Index of the element of X which is the least upper
*                bound to XVAL.  Indices are numbered from 1.  If two
*                or more elements of X are equal candidates, INDX is
*                set to the smallest of the indices.  INDX is set to
*                zero, if no candidate is found.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.7 $  $Date: 1995/03/08 15:05:36 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VLUB (X, N, XVAL, XLUB, INDX)


      INTEGER N,INDX
      INTEGER I

      REAL XVAL,XLUB
      REAL X(*)


* Search for the smallest X(i) satisfying X(i) >= XVAL
      INDX=0
      XLUB=XVAL
      DO 100 I=1,N
        IF (X(I).GE.XVAL) THEN
          IF (INDX.EQ.0 .OR. X(I).LT.XLUB) THEN
            INDX=I
            XLUB=X(I)
          END IF
        END IF
 100  CONTINUE


      RETURN

      END
