*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VLOG10 (X, Y, N)
*
*
* Purpose:
*     Logarithm (base 10) of each element of a vector
*
*
* Description:
*     This routine converts each element of the input vector to a log
*     (base 10) value.
*
*       y(i) =  log10(x(i))  for i from 1 to N.
*
*     However, if x(i) is nonpositive, y(i) is set to -1E6.
*
*
* Parameters:
* R ->  X      - Input vector, all elements must be positive.
* R <-  Y      - Output vector (the output vector may be the same as
*                the input vector)
* I ->  N      - Number of elements in each of X and Y.  N may be zero.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:05:33 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VLOG10 (X, Y, N)


      INTEGER N
      INTEGER NN,I

      REAL X(*),Y(*)


      NN=0
      DO 100 I=1,N
        IF (X(I).GT.0.0) THEN
          Y(I)=LOG10(X(I))
        ELSE
          NN=NN+1
          Y(I)=-1E6
        END IF
 100  CONTINUE

      IF (NN.NE.0) CALL WARN('VLOG10 - Nonpositive input value(s)')


      RETURN

      END
