*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VGLB (X, N, XVAL, XLB, INDX)
*
*
* Purpose:
*     Find the largest element less than a given value
*
*
* Description:
*     This subroutine searches the input array for the largest element
*     which is less than or equal to XVAL.  If no element is less than
*     or equal to XVAL, the value XVAL is returned.
*
*
* Parameters:
* R ->  X      - Input array of values
* I ->  N      - Number of elements in X
* R ->  XVAL   - Reference value
* R <-  XGLB   - Returned value, XGLB=X(INDX) if INDX > 0
*                                XGLB=XVAL    if INDX = 0
* I <-  INDX   - Index of the element of X which is the greatest lower
*                bound to XVAL.  Indices are numbered from 1.  If two
*                or more elements of X are equal candidates, INDX is
*                set to the smallest of the indices.  INDX is set to
*                zero, if no candidate is found.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:05:28 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VGLB (X, N, XVAL, XGLB, INDX)


      INTEGER N,INDX
      INTEGER I

      REAL XVAL,XGLB
      REAL X(*)


* Search for the largest X(i) satisfying X(i) <= XVAL
      INDX=0
      XGLB=XVAL
      DO 100 I=1,N
        IF (X(I).LE.XVAL) THEN
          IF (INDX.EQ.0 .OR. X(I).GT.XGLB) THEN
            INDX=I
            XGLB=X(I)
          END IF
        END IF
 100  CONTINUE


      RETURN

      END
