*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VEXTNT (X, NX, THR, IL, IU)
*
*
* Purpose:
*     Find the significant extent of the values in a vector
*
*
* Description:
*     This routine finds the indices of the first and last significant
*     elements of a vector.  Elements are considered significant if the
*     have a magnitude equal to or exceeding a given threshold.
*
*
* Parameters:
* R ->  X      - Input vector
* I ->  NX     - Number of elements in X
* R ->  THR    - Magnitude threshold
* I <-  IL     - X(IL) is the first element in X, with abs(X(IL)) >=
*                THR.  IL is a value from 1 to NX.  IL is set to 1 if
*                no element is larger than the magnitude threshold.
* I <-  IU     - X(IL) is the last element in X, with abs(X(IL)) >=
*                THR.  IU is normally a value from IL to NX, but IU is
*                set to 0 if no element is larger than the magnitude
*                threshold.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:05:25 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VEXTNT (X, NX, THR, IL, IU)


      INTEGER NX,IL,IU

      REAL THR
      REAL X(*)


      DO 140 IU=NX,1,-1
        IF (ABS(X(IU)).GE.THR) THEN
          DO 120 IL=1,IU-1
            IF (ABS(X(IL)).GE.THR) GO TO 900
 120      CONTINUE
          GO TO 900
        END IF
 140  CONTINUE
      IL=1


 900  RETURN

      END
