*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VDBV (X, Y, N)
*
*
* Purpose:
*     Convert the elements of a vector to dB (voltage)
*
*
* Description:
*     This routine converts each element of the input vector to a
*     voltage ratio decibel value.
*
*       y(i) =  20*log10(y(i))  for i from 1 to N.
*
*     However, if x(i) is nonpositive, y(i) is set to -1E6.
*
*
* Parameters:
* R ->  X      - Input vector, all elements should be positive
* R <-  Y      - Output vector (the output vector may be the same as
*                the input vector)
* I ->  N      - Number of elements in each of X and Y.  N may be zero.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:05:17 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VDBV (X, Y, N)


      INTEGER N
      INTEGER NN,I

      REAL X(*),Y(*)


      NN=0
      DO 100 I=1,N
        IF (X(I).GT.0.0) THEN
          Y(I)=20.*LOG10(X(I))
        ELSE
          NN=NN+1
          Y(I)=-1E6
        END IF
 100  CONTINUE

      IF (NN.NE.0) CALL WARN('VDBV - Nonpositive input value(s)')


      RETURN

      END
