*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE VCLIP (X, Y, N, YMIN, YMAX)
*
*
* Purpose:
*     Clip elements of a vector
*
*
* Description:
*     This routine clips an array of data.  Data values below YMIN are
*     replaced by YMIN, while data values above YMAX are replaced by
*     YMAX.
*
*
* Parameters:
* R ->  X       - Array of samples to be clipped
* R <-  Y       - Output array
* I ->  N       - Number of elements in X
* R ->  YMIN    - Lower clipping level
* R ->  YMAX    - Upper clipping level (YMAX >= YMIN)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.4 $  $Date: 1995/03/08 15:05:09 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE VCLIP (X, Y, N, YMIN, YMAX)


      INTEGER N
      INTEGER I

      REAL YMIN,YMAX
      REAL X(*),Y(*)


      DO 100 I=1,N
        IF (X(I).GE.YMAX) THEN
          Y(I)=YMAX
        ELSE IF (X(I).LE.YMIN) THEN
          Y(I)=YMIN
        ELSE
          Y(I)=X(I)
        END IF
 100  CONTINUE


      RETURN

      END
