*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE AMINMX (X, N, XMIN, XMAX)
*
*
* Purpose:
*     Accumulate the minimum and maximum values in an array
*
*
* Description:
*     Given initial minimum and maximum values, this routine determines
*     the minimum and maximum of these given values and the values in
*     an array of values.
*
*
* Parameters:
* R ->  X      -  Input array
* I ->  N      -  Number of elements of X
* R <-> XMIN   -  Minimum value.  On input the given minimum, on output
*                 the smaller of the input value and the minimum valued
*                 element in the array.
* R <-> XMAX   -  Maximum value.  On input the given maximum, on output
*                 the larger of the input value and the maximum valued
*                 element in the array.
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 14:47:39 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE AMINMX (X, N, XMIN, XMAX)


      INTEGER N
      INTEGER I

      REAL XMIN,XMAX
      REAL X(*)


* Update the minimum and maximum values
      DO 100 I=1,N
        XMAX=MAX(X(I),XMAX)
        XMIN=MIN(X(I),XMIN)
 100  CONTINUE


      RETURN

      END
