*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     INTEGER FUNCTION IEXPSC (VMIN, VMAX, ILL, IUL, ILOG)
*
*
* Purpose:
*     Find the exponent for a data scale
*
*
* Description:
*     This routine uses the algorithm used by the plotting routines to
*     choose a power of ten exponent for labelling the axes.  For log
*     plots, this routine attempts to find a power of ten exponent
*     which will allow the decade marks to avoid power of 10 labels.
*
*
* Parameters:
* I <-  IEXPSC - Exponent for representing the data (multiple of 3)
*
* R ->  VMIN   - Minimum data value
* R ->  VMAX   - Maximum data value
* I ->  ILL    - Lower limit option
*                1 - The lower limit of the graph is to be a tick value
*                    less than or equal to VMIN
*                2 - The lower limit of the graph is to be VMIN
* I ->  IUL    - Upper limit option
*                1 - The upper limit of the graph is to be a tick value
*                    greater than or equal to VMAX
*                2 - The upper limit of hte graph is to be VMAX
* I ->  ILOG   - Log axis option,
*                0 - linear axis
*                1 - log axis
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.6 $  $Date: 1995/03/08 15:45:39 $
*
*
*-----------------------------------------------------------------------

      INTEGER FUNCTION IEXPSC (VMIN, VMAX, ILL, IUL, ILOG)


      INTEGER LINS,LOGS,MXTICK
      PARAMETER (LINS=0,LOGS=1)
      PARAMETER (MXTICK=100)

      INTEGER ILL,IUL,ILOG
      INTEGER IAX,NTICK,IE,ILMIN,ILMAX
      INTEGER IFLORX,ICEILX

      CHARACTER*20 ALABEL(MXTICK)

      REAL VMIN,VMAX
      REAL DMIN,DMAX,TMIN,TMAX
      REAL ATICK(MXTICK)


      IAX=ILL+4*IUL+64*ILOG
      NTICK=0
      CALL AXLIMS(ATICK,MXTICK,0,1,VMIN,VMAX,ATICK,NTICK,
     -            IAX,DMIN,DMAX)
      CALL AXSCAL(DMIN,DMAX,IAX,TMIN,TMAX,
     -            ATICK,ALABEL,NTICK,IE)

      IF (IE.EQ.0 .AND. ILOG.EQ.LOGS) THEN
        ILMIN=IFLORX(LOG10(TMIN))
        ILMAX=ICEILX(LOG10(TMAX))
        IF (ILMIN.GE.2 .AND. ILMAX.LE.6) THEN
          IE=3
        ELSE IF (ILMIN.GE.5 .AND. ILMAX.LE.9) THEN
          IE=6
        ELSE IF (ILMIN.GE.8 .AND. ILMAX.LE.12) THEN
          IE=9
        END IF
      END IF

      IEXPSC=IE


      RETURN

      END
