*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE ABSCAL (X, NPT, XMIN, XMAX, NFREQ, IPLOT, IFAXIS,
*                         XLABEL, NCXL, XUNITS, NCXU)
*
*
* Purpose:
*     Determine an abscissa scale for a filter response plot
*
*
* Description:
*     The abscissa can represent either frequency or time.  If the
*     frequency scale can be expressed in kHz, MHz or GHz, appropriate
*     scaling of the minimum and maximum frequency values is done.  The
*     time scale, if it can be expressed in ms, us, ns, or ps is also
*     scaled.
*
*
* Parameters:
* R <-> X      - Abscissa samples, returned scaled if necessary
* I ->  NPT    - Number of samples
* R <-> XMIN   - Minimum value, returned scaled if necessary
* R <-> XMAX   - Maximum value, returned scaled if necessary
* L ->  NFREQ  - Logical variable, .TRUE. if normalized frequency is
*                being used.
* I ->  IPLOT  - Type of plot,
*                1 - linear amplitude
*                2 - dB amplitude
*                3 - log amplitude
*                4 - group delay
*                5 - phase response
*                6 - radian phase
*                7 - impulse response
* I ->  IFAXIS - Frequency axis options,
*                0 - linear frequency (Hz)
*                1 - log frequency (Hz)
*                2 - linear radian frequency
*                3 - log radian frequency
* C <-  XLABEL - "Normalized Frequency", "Frequency" or
*                "Time"
* I <-  NCXL   - Number of characters in XLABEL (max 24)
* C <-  XUNITS - "Hz", "kHz", "MHz", or "GHz" for frequency axes,
*                "P rad" for radian frequency axes,
*                "samples", "sec", "ms", "us", "ns", or "ps" for
*                time axes
* I <-  NCXU   - Number of characters in XUNITS (max 7)
*
*
* Author / revision:
*     P. Kabal
*     $Revision: 1.5 $  $Date: 1995/03/08 15:45:26 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE ABSCAL (X, NPT, XMIN, XMAX, NFREQ, IPLOT, IFAXIS,
     -                   XLABEL, NCXL, XUNITS, NCXU)


      INTEGER TICKV,EXACTV
      PARAMETER (TICKV=1,EXACTV=2)
      INTEGER LINAR,DBAR,LOGAR,DELYR,PHASD,PHASR,IMPLR
      PARAMETER (LINAR=1,DBAR=2,LOGAR=3,DELYR=4,PHASD=5,PHASR=6,
     -           IMPLR=7)
      INTEGER LINS,LOGS,CFREQ,RFREQ
      PARAMETER (LINS=0,LOGS=1,CFREQ=0,RFREQ=1)

      INTEGER NPT,IPLOT,IFAXIS,NCXL,NCXU
      INTEGER ILL,IUL,ILOG,IRAD,IEXP
      INTEGER IEXPSC,LENSTR

      LOGICAL NFREQ

      CHARACTER*(*) XLABEL,XUNITS
      CHARACTER*1 CPI,CMU

      REAL X(NPT)
      REAL XMIN,XMAX
      REAL VMIN,VMAX,SF


* Get the exponent of the scaling factor
      VMIN=XMIN
      VMAX=XMAX
      ILL=EXACTV
      IUL=EXACTV
      IF (VMIN.GE.VMAX) THEN
        CALL AMINMX(X,NPT,VMIN,VMAX)
        ILL=TICKV
        IUL=TICKV
      END IF
      ILOG=MOD(IFAXIS,2)
      IRAD=MOD(IFAXIS/2,2)
      IEXP=IEXPSC(VMIN,VMAX,ILL,IUL,ILOG)

* Frequency axes
      IF (IPLOT.NE.IMPLR) THEN

        IF (NFREQ) THEN
          XLABEL='Normalized Frequency'
          IF (IRAD.EQ.CFREQ) THEN
            XUNITS='Hz'
            SF=1.
          ELSE
            CPI=CHAR(182)
            XUNITS=CPI//' rad'
            SF=2.
          END IF

* Scale frequency range to kHz, MHz or GHz
        ELSE IF (IRAD.EQ.CFREQ) THEN
          XLABEL='Frequency'
          IF (IEXP.EQ.3) THEN
            XUNITS='kHz'
            SF=1E-3
          ELSE IF (IEXP.EQ.6) THEN
            XUNITS='MHz'
            SF=1E-6
          ELSE IF (IEXP.EQ.9) THEN
            XUNITS='GHz'
            SF=1E-9
          ELSE
            XUNITS='Hz'
            SF=1.
          END IF

* Radian frequency
        ELSE
          XLABEL='Frequency'
          CPI=CHAR(182)
          XUNITS=CPI//' rad'
          SF=2.

        END IF

* Time response
      ELSE

        IF (NFREQ) THEN
          XLABEL='Normalized Time'
          XUNITS='samples'
          SF=1.

* Scale time range to ms, us, ns, or ps
        ELSE
          XLABEL='Time'
          IF (IEXP.EQ.-3) THEN
            XUNITS='ms'
            SF=1E+3
          ELSE IF (IEXP.EQ.-6) THEN
            CMU=CHAR(181)
            XUNITS=CMU//'s'
            SF=1E+6
          ELSE IF (IEXP.EQ.-9) THEN
            XUNITS='ns'
            SF=1E+9
          ELSE IF (IEXP.EQ.-12) THEN
            XUNITS='ps'
            SF=1E+12
          ELSE
            XUNITS='sec'
            SF=1.
          END IF

        END IF

      END IF

* Scale the data
      IF (SF.NE.1.) THEN
        XMIN=SF*XMIN
        XMAX=SF*XMAX
        CALL VSMULN(X,SF,X,NPT)
      END IF

* See if a power of ten annotation will be added
      IEXP=IEXPSC(SF*VMIN,SF*VMAX,ILL,IUL,ILOG)

* Return the number of characters in the strings
      NCXL=LENSTR(XLABEL)
      IF (IEXP.NE.0) NCXL=NCXL+6
      NCXU=LENSTR(XUNITS)


      RETURN

      END
