/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double VRfSum (const float x[], int N)

Purpose:
  Calculate the sum of elements in an array of floats

Description:
  This routine calculates the sum of the elements in an array of floats,
        N-1
    s = SUM x[i] .
        i=0

Parameters:
  <-  double VRfSum
      Sum of the elements
   -> const float x[]
      Input array (N elements)
   -> int N
      Number of elements in the array (may be zero)

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.2 $  $Date: 1995/02/09 21:12:17 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfSum.c 1.2 1995/02/09 libtsp-V2R7a $";

#include <libtsp.h>

double
VRfSum (x, N)

     const float x[];
     int N;

{
  int i;
  double s;

  s = 0.0;
  for (i = 0; i < N; ++i)
    s += x[i];

  return s;
}
