/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void VRfLog10 (const float x[], float y[], int N)

Purpose:
  Find the logarithm (base 10) of each element of an array

Description:
  This routine finds the logarithm (base 10) for each element of an array.
    y[i] = log10(x[i]),  0 <= i < N.

Parameters:
   -> const float x[]
      Input array (N elements)
  <-  float y[]
      Output array (N elements).  The output array can be the same as the input
      array.
   -> int N
      Number of elements in the arrays (may be zero)

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.5 $  $Date: 1996/05/06 20:39:05 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfLog10.c 1.5 1996/05/06 libtsp-V2R7a $";

#include <math.h>
#include <libtsp.h>

void
VRfLog10 (x, y, N)

     const float x[];
     float y[];
     int N;

{
  int i;

  for (i = 0; i < N; ++i) {
    if (x[i] >= 0)
      y[i] = log10 (x[i]);
    else
      UThalt ("VRfLog10: Negative input value(s)");
  }

  return;
}
