/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void VRfAmpldB (const float ampl[], float dB[], int N)

Purpose:
  Convert each value in an array of amplitudes to a decibel value

Description:
  This routine converts the elements of an array of amplitudes to decibels.
    dB[i] = 20 * log10(ampl[i]),  0 <= i < N.
  The value ampl[i] must be non-negative.  If ampl[i] is zero, dB[i] is set to
  -1e6 (with a warning).

Parameters:
   -> const float ampl[]
      Input amplitude array (N elements).  This values must be non-negative.
  <-  float y[]
      Output array of decibel values (N elements).  The output array can be the
      same as the input array.
   -> int N
      Number of elements in the arrays (may be zero)

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.5 $  $Date: 1996/05/06 20:38:13 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: VRfAmpldB.c 1.5 1996/05/06 libtsp-V2R7a $";

#include <math.h>
#include <libtsp.h>

#define NEG_INFTY	-1e6

void
VRfAmpldB (ampl, dB, N)

     const float ampl[];
     float dB[];
     int N;

{
  int i, nn;

  nn = 0;
  for (i = 0; i < N; ++i) {
    if (ampl[i] > 0)
      dB[i] = 20.0 * log10 (ampl[i]);
    else if (ampl[i] == 0) {
      dB[i] = NEG_INFTY;
      ++nn;
    }
    else
      UThalt ("VRfAmpldB: Negative input amplitude");
  }
  if (nn != 0)
    UTwarn ("VRfAmpldB - Zero input amplitude(s)");

  return;
}
