/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void UThalt (const char Errmsg[], ...)

Purpose:
  Print an error message, stop with error status set

Description:
  This routine prints an error message to stderr (standard error) and then
  terminates execution with exit status set to EXIT_FAILURE.  An example of the
  use of this routine is as follows.
    UThalt ("%s: Invalid option", PROGRAM);

Parameters:
   -> const char Errmsg[]
      Character string to be printed.  This string can contain optional
      formatting codes.  The arguments corresponding to the formatting codes
      appear at the end of the argument list.  The input string should not
      normally have a terminating newline character, since this routine
      supplies a newline.
   -> <args...>
      Arguments corresponding to the formatting codes.  The format string and
      the variable number of arguments is passed on to the system routine
      vprintf.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.16 $  $Date: 1995/05/20 10:21:52 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UThalt.c 1.16 1995/05/20 libtsp-V2R7a $";

#ifdef __STDC__

#include <stdio.h>
#include <stdlib.h>		/* definition of exit */
#include <stdarg.h>		/* ANSI C variable-length argument list */
#include <libtsp.h>

#ifndef EXIT_FAILURE
#  define EXIT_FAILURE	1	/* Normally in stdlib.h */
#endif

void
UThalt (const char Errmsg[], ...)

{
  va_list ap;

  va_start (ap, Errmsg);

/* Print the error message */
  vfprintf (stderr, Errmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);

  exit (EXIT_FAILURE);
}

#else /* not __STDC__ */

#include <stdio.h>
#include <stdlib.h>		/* definition of exit */
#include <varargs.h>		/* K&R C variable-length argument list */
#include <libtsp.h>

#ifndef EXIT_FAILURE
#  define EXIT_FAILURE	1	/* Normally in stdlib.h */
#endif

void
UThalt (va_alist)

     va_dcl

{
  va_list ap;
  char *Errmsg;

  va_start (ap);
  Errmsg = va_arg (ap, char *);

/* Print the error message */
  vfprintf (stderr, Errmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);

  exit (EXIT_FAILURE);
}
#endif /* __STDC__ */
