/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *STtrimIws (const char Si[])

Purpose:
  Trim leading white-space

Description:
  This routine returns a pointer to the first character in a string that is not
  white-space (as defined by isspace).  If the input string consists entirely
  of white-space, this routine returns a pointer to the terminating null
  character.

Parameters:
  <-  char *STrimIws
      Pointer to the first non-white-space character
   -> const char Si[]
      Input character string

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.4 $  $Date: 1995/02/09 21:33:13 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STtrimIws.c 1.4 1995/02/09 libtsp-V2R7a $";

#include <ctype.h>
#include <libtsp/nucleus.h>

char *
STtrimIws (Si)

     const char Si[];

{
  const char *p;

  /* Find the first non-white-space character */
  for (p = Si; *p != '\0'; ++p) {
    if (! isspace (*p))
      break;
  }

  return ((char *) p);
}
