/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecIfrac (const char String[], int *Ival1, int *Ival2)

Purpose:
  Decode a ratio specification of two integer values

Description:
  This routine decodes a string specifying a ratio of integer values.  The
  ratio is specified in the form "V" or "V1/V2", for example "-23 / 45".
  Optional white-space (as defined by isspace) can surround the values.  For
  the case of a single value V, this is equivalent to the ratio "V/1".  If an
  error is encountered, neither output value is set.

Parameters:
  <-  int STdecIfrac
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  int *Ival1
      First value
  <-  int *Ival2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/05/31 19:09:56 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecIfrac.c 1.2 1996/05/31 libtsp-V2R7a $";

#include <math.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdecIfrac (String, Ival1, Ival2)

     const char String[];
     int *Ival1;
     int *Ival2;

{
  int N;
  int ival1, ival2;

  /* Decode the ratio values */
  N = STdecPair (String, "/", 'I', (void *) (&ival1), (void *) (&ival2));

  if (N == 1)
    ival2 = 1;
  if (N > 0) {
    *Ival1 = ival1;
    *Ival2 = ival2;
  }

  return (N <= 0);
}
